﻿using System.ComponentModel.DataAnnotations;

namespace WebApplication1.Models
{
    public class FirstNameValidation:ValidationAttribute
    {
        protected override ValidationResult IsValid(object value, ValidationContext validationContext)
        {
            if (value == null) // Checking for Empty Value
            {
                return new ValidationResult("Please Provide First Name");
            }
            else
            {
                if (value.ToString().Contains("@"))
                {
                    return new ValidationResult("First Name should contain @");
                }
            }
            return ValidationResult.Success;
        }
    }
    public class Employee
    {
        [Key]
        public int EmployeeId  { get; set; }

        [FirstNameValidation]
        public string FirstName { get; set; }

        [StringLength(5,ErrorMessage="Last Name length should not be greater than 5")]
        public string LastName { get; set; }

        [Range(typeof(int), "5000", "50000", ErrorMessage = "Put a proper Salary value between 5000 and 50000")]
        public int? Salary { get; set; }
    }
}